local assets=
{
	Asset("ANIM", "anim/stingermine.zip"),
	Asset("ATLAS", "images/inventoryimages/stingermine.xml"),  
	Asset("IMAGE", "images/inventoryimages/stingermine.tex"),
	
}


local function onfinished(inst)
    inst:RemoveComponent("inventoryitem")
    inst:RemoveComponent("mine")
    inst:RemoveComponent("explosive")
    inst.persists = false
    --inst.AnimState:PushAnimation("used", false)
    --inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
    inst:Remove()
end

--[[local function onfinished_maxwell(inst)
    inst:RemoveComponent("mine")
    inst.persists = false
	inst:DoTaskInTime(1.25, function()
		inst.AnimState:PlayAnimation("used", false)
		inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
		inst:DoTaskInTime(3, function() inst:Remove() end )
	end)
end]]

local function OnExplode(inst)
	inst.AnimState:PlayAnimation("leap")	
	inst.AnimState:PushAnimation("blow", false)
	local pos = Vector3(inst.Transform:GetWorldPosition())
    --inst.SoundEmitter:KillSound("hiss")
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")

	local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, 5)
    for k,v in pairs(ents) do
        local inpocket = v.components.inventoryitem and v.components.inventoryitem:IsHeld()

        if not inpocket then
        	--if v.components.workable and not v:HasTag("busy") then --Haaaaaaack!
                --v.components.workable:WorkedBy(self.inst, self.buildingdamage)
            --[[else]]if v.components.burnable and not v.components.fueled then
                v.components.burnable:Ignite()
            end
        end
        if v.components.combat and v ~= inst then
            v.components.combat:GetAttacked(inst, 100, nil)
        end            
    end

    local explode = SpawnPrefab("explode_small")
    local pos = inst:GetPosition()
    explode.Transform:SetPosition(pos.x, pos.y, pos.z)

    --local explode = PlayFX(pos,"explode", "explode", "small")
    explode.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    explode.AnimState:SetLightOverride(1)

    if inst.components.finiteuses then
	    inst.components.finiteuses:Use(1)
    end
   --[[ inst.AnimState:PlayAnimation("trap")
    if target then
        inst.SoundEmitter:PlaySound("dontstarve/common/trap_teeth_trigger")
	    target.components.combat:GetAttacked(inst, TUNING.TRAP_TEETH_DAMAGE)
        if METRICS_ENABLED then
			FightStat_TrapSprung(inst,target,TUNING.TRAP_TEETH_DAMAGE)
		end
    end
    if inst.components.finiteuses then
	    inst.components.finiteuses:Use(1)
    end]]
end

local function OnReset(inst)
    --[[inst.SoundEmitter:PlaySound("dontstarve/common/trap_teeth_reset")
	inst.AnimState:PlayAnimation("reset")
	]]inst.AnimState:PlayAnimation("idle", false)
	local minimap = inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "stingermineredo.tex" )	
end

local function SetSprung(inst)
    --inst.AnimState:PlayAnimation("trap_idle")
end

local function SetInactive(inst)
    inst.AnimState:PlayAnimation("inactive")
end

local function OnDropped(inst)
	inst.components.mine:Deactivate()
end

local function ondeploy(inst, pt, deployer)
	
	inst.components.mine:Reset()
	inst.Physics:Teleport(pt:Get())	
end

--legacy save support - mines used to start out activated
local function onload(inst, data)
	if not data or not data.mine then
		inst.components.mine:Reset()
	end
end

local function MakeStingerMine()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local s  = 0.35
    inst.Transform:SetScale(s,s,s)
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "stingermineredo.png" )
   
	anim:SetBank("stingermine")
	anim:SetBuild("stingermine")
	anim:PlayAnimation("idle")
	
	inst:AddTag("trap")
	
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.nobounce = true
	inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
	inst.components.inventoryitem.imagename = "stingermine"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/stingermine.xml"
	
	inst:AddComponent("mine")
	inst.components.mine:SetRadius(2)
	inst.components.mine:SetAlignment("player")
	inst.components.mine:SetOnExplodeFn(OnExplode)
	inst.components.mine:SetOnResetFn(OnReset)
	inst.components.mine:SetOnSprungFn(SetSprung)
	inst.components.mine:SetOnDeactivateFn(SetInactive)
	--inst.components.mine:StartTesting()

	inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplode)
    --inst.components.explosive:SetOnIgniteFn(OnIgniteFn)
    inst.components.explosive.explosivedamage = TUNING.GUNPOWDER_DAMAGE
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(1)
	inst.components.finiteuses:SetUses(1)
	inst.components.finiteuses:SetOnFinished( onfinished )
	
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = ondeploy
    inst.components.deployable.min_spacing = .75
	
	inst.components.mine:Deactivate()
	inst.OnLoad = onload
	return inst
end

return Prefab( "common/inventory/stingermine", MakeStingerMine, assets)
		--MakePlacer("stingermine_placer", "stingermine", "stingermine", "idle")

